#include <iostream>
#include <bits/stdc++.h>
#define int long long


using namespace std;


struct seg{
    int x1, y1, x2, y2;
};

vector<int> pr, cnt, e;

int get_root(int v){
    if (pr[v] == v) return v;
    pr[v] = get_root(pr[v]);
    return pr[v];
}

void unite(int i, int j, int t){
    int u = get_root(i);
    int v = get_root(j);
    if (u == v){
        if (t == 0){
            e[u] ++;
        } else {
            cnt[u]++;
            e[u] += 2;
        }
        return;
    }
    if (cnt[u] < cnt[v]) swap(u, v);
    pr[v] = u;
    cnt[u] += cnt[v];
    e[u] += e[v];
    if (t == 0){
        e[u] ++;
    } else {
        cnt[u]++;
        e[u] += 2;
    }
}

struct point{
    int x, y;
};

int operator * (point a, point b){
    return a.x * b.y - a.y * b.x;
}

point operator - (point a, point b){
    return {a.x - b.x, a.y - b.y};
}

int intersect(seg a, seg b){
    point k = {a.x1, a.y1};
    point l = {a.x2, a.y2};
    point m = {b.x1, b.y1};
    point n = {b.x2, b.y2};

    point o = m - n;
    point x1 = k - n, x2 = l - n;
    int t1 = (o * x1) * (o * x2);

    o = l - k, x1 = m - k, x2 = n - k;
    int t2 = (o * x1) * (o * x2);

    if (t1 <= 0 && t2 <= 0){
        if (t1 * t2 == 0) return 0;
        return 1;
    }

    return -1;
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int t;
    cin >> t;
    while (t --){
        int n;
        cin >> n;

        pr.assign(n, 0), cnt.assign(n, 0), e.assign(n, 0);
        for (int i = 0; i < n; i ++){
            pr[i] = i;
            cnt[i] = 2;
            e[i] = 1;
        }

        vector<seg> p(n);
        for (int i = 0; i < n; i ++){
            seg c;
            cin >> c.x1 >> c.y1 >> c.x2 >> c.y2;
            p[i] = c;
            for (int j = 0; j < i; j ++){
                int m = intersect(p[j], p[i]);
                if (m >= 0){
                    unite(i, j, m);
                }
            }
        }

        vector<int> used(n, 0);
        int ans = 0;
        for (int i = 0; i < n; i ++){
            int r = get_root(i);
            if (used[r]) continue;
            used[r] = 1;
            ans += e[r] - cnt[r] + 1;
        }
        cout << ans + 1 << "\n";
    }
    return 0;
}

/*
 1
 5
1 4 1 1
3 3 0 1
1 2 0 3
3 3 1 3
2 3 3 2
 */
